/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.art_of_forging.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.acetheeldritchking.art_of_forging.item.CustomHexCodec;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
public class ScrollHelper {
    private static final Codec<ScrollHelper> codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("key").forGetter(i -> i.key), (App)Codec.STRING.optionalFieldOf("details").forGetter(i -> Optional.ofNullable(i.details)), (App)Codec.BOOL.fieldOf("intricate").forGetter(i -> i.isIntricate), (App)Codec.INT.fieldOf("material").forGetter(i -> i.material), (App)CustomHexCodec.instance.fieldOf("ribbon").forGetter(i -> i.ribbon), (App)Codec.INT.listOf().optionalFieldOf("glyphs", Collections.emptyList()).forGetter(i -> i.glyphs), (App)ResourceLocation.f_135803_.listOf().optionalFieldOf("schematics", Collections.emptyList()).forGetter(i -> i.schematics), (App)ResourceLocation.f_135803_.listOf().optionalFieldOf("effects", Collections.emptyList()).forGetter(i -> i.craftingEffects)).apply((Applicative)instance, ScrollHelper::new));
    public String key;
    public String details;
    public boolean isIntricate;
    public int material = 0;
    public int ribbon = 0xFFFFFF;
    public List<Integer> glyphs = Collections.emptyList();
    public List<ResourceLocation> schematics = Collections.emptyList();
    public List<ResourceLocation> craftingEffects = Collections.emptyList();

    public ScrollHelper() {
        this.key = "unknown";
    }

    public ScrollHelper(String name, Optional<String> details, boolean isIntricate, int material, int ribbon, List<Integer> glyphs, List<ResourceLocation> schematics, List<ResourceLocation> craftingEffects) {
        this.key = name;
        this.details = details.orElse(null);
        this.isIntricate = isIntricate;
        this.material = material;
        this.ribbon = ribbon;
        this.glyphs = glyphs;
        if (!schematics.isEmpty()) {
            this.schematics = schematics;
        }
        if (!craftingEffects.isEmpty()) {
            this.craftingEffects = craftingEffects;
        }
    }

    public static CompoundTag write(ScrollHelper[] data, CompoundTag tag) {
        ListTag list = Arrays.stream(data).map(scroll -> codec.encodeStart((DynamicOps)NbtOps.f_128958_, scroll)).map(DataResult::result).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toCollection(ListTag::new));
        tag.m_128365_("data", (Tag)list);
        return tag;
    }

    public void write(ItemStack itemStack) {
        itemStack.m_41700_("BlockEntityTag", (Tag)ScrollHelper.write(new ScrollHelper[]{this}, new CompoundTag()));
    }
}

